<?php

namespace ps_metrics_module_v4_0_6\Http\Message\Decorator;

use Psr\Http\Message\StreamInterface;
/**
 * Decorates a stream.
 *
 * @author Márk Sági-Kazár <mark.sagikazar@gmail.com>
 */
trait StreamDecorator
{
    /**
     * @var StreamInterface
     */
    protected $stream;
    public function __toString() : string
    {
        return $this->stream->__toString();
    }
    public function close() : void
    {
        $this->stream->close();
    }
    public function detach()
    {
        return $this->stream->detach();
    }
    public function getSize() : ?int
    {
        return $this->stream->getSize();
    }
    public function tell() : int
    {
        return $this->stream->tell();
    }
    public function eof() : bool
    {
        return $this->stream->eof();
    }
    public function isSeekable() : bool
    {
        return $this->stream->isSeekable();
    }
    public function seek(int $offset, int $whence = \SEEK_SET) : void
    {
        $this->stream->seek($offset, $whence);
    }
    public function rewind() : void
    {
        $this->stream->rewind();
    }
    public function isWritable() : bool
    {
        return $this->stream->isWritable();
    }
    public function write(string $string) : int
    {
        return $this->stream->write($string);
    }
    public function isReadable() : bool
    {
        return $this->stream->isReadable();
    }
    public function read(int $length) : string
    {
        return $this->stream->read($length);
    }
    public function getContents() : string
    {
        return $this->stream->getContents();
    }
    public function getMetadata(?string $key = null)
    {
        return $this->stream->getMetadata($key);
    }
}
